////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  OBColor.h
//    A typedef file for Colors used in the CrossPlatform code.
//
//  Copyright (C) 2010 MYOB US, Inc., all rights reserved.
//
//  Change History (most recent first):
//
//	09/16/10  G.R.W.  Created file from Ken's changes
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma once
#include "CrossPlatform/CPExternalAPIMacros.h"

class EXTERNAL_API OBColor
{
public:
	static OBColor ColorWithPercentageRedGreenBlueAlpha(float Red, float Green, float Blue, float Alpha);
	static OBColor ColorWithPercentageAlphaRedGreenBlue(float Alpha, float Red, float Green, float Blue);

#ifdef _WINDOWS
	static OBColor ColorWithAlphaRedGreenBlue(int ARGB);
#endif

	OBColor(void);
	OBColor(const OBColor& Color);
	virtual ~OBColor(void);

	const OBColor& operator=(const OBColor& Color);

	void SetRedPercentage(float RedPercentage);
	void SetGreenPercentage(float GreenPercentage);
	void SetBluePercentage(float BluePercentage);
	void SetAlphaPercentage(float AlphaPercentage);

protected:
	OBColor(float Red, float Green, float Blue, float Alpha);
	void SetColorWithPercentageRedGreenBlueAlpha(float Red, float Green, float Blue, float Alpha);

#ifdef _WINDOWS
public:
	operator int(void) const;
	int ToARGB(void) const;

protected:
	OBColor(int ARGB);
#endif
#ifdef _MAC
public:
	OBColor(RGBColor ColorIn);
	operator RGBColor(void) const;
	int ToRGBColor(void) const;
#endif

private:
	float m_Red;
	float m_Green;
	float m_Blue;
	float m_Alpha;

public:
	const float& red;
	const float& green;
	const float& blue;
	const float& alpha;
};
